/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.textures.GpuTexture;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9334;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.cache.model.cuboid.GeoCube;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.base.RenderPassInfo;

public final class RenderUtil {
    public static void transformToBone(class_4587 poseStack, GeoBone bone) {
        ObjectArrayList boneQueue = new ObjectArrayList();
        GeoBone parent = bone;
        boneQueue.add(bone);
        while ((parent = parent.parent()) != null) {
            boneQueue.add(parent);
        }
        for (GeoBone bone2 : boneQueue) {
            RenderUtil.prepMatrixForBone(poseStack, bone2);
        }
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, GeoBone bone) {
        bone.translateToPivotPoint(poseStack);
        float xRot = bone.baseRotX();
        float yRot = bone.baseRotY();
        float zRot = bone.baseRotZ();
        if (bone.frameSnapshot != null) {
            xRot += bone.frameSnapshot.getRotX();
            yRot += bone.frameSnapshot.getRotY();
            zRot += bone.frameSnapshot.getRotZ();
        }
        if (zRot != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(zRot));
        }
        if (yRot != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(yRot));
        }
        if (xRot != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(xRot));
        }
    }

    public static void prepMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.prepMatrixForBoneAndUpdateListeners(poseStack, bone, null);
    }

    public static void prepMatrixForBoneAndUpdateListeners(class_4587 poseStack, GeoBone bone, @Nullable RenderPassInfo<?> renderPassInfo) {
        if (bone.frameSnapshot != null) {
            bone.frameSnapshot.translate(poseStack);
        }
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        if (bone.frameSnapshot != null) {
            bone.frameSnapshot.scale(poseStack);
        }
        if (renderPassInfo != null) {
            bone.updateBonePositionListeners(poseStack, renderPassInfo);
        }
        bone.translateAwayFromPivotPoint(poseStack);
    }

    public static class_243 renderPoseToPosition(Matrix4fc pose, float xScale, float yScale, float zScale) {
        Vector4f position = pose.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new class_243((double)(position.x() * xScale), (double)(position.y() * yScale), (double)(position.z() * zScale));
    }

    public static Matrix4f extractPoseFromRoot(Matrix4fc baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul(baseMatrix);
        return inputMatrix;
    }

    public static Matrix4f addPosToMatrix(Matrix4f baseMatrix, class_243 pos) {
        baseMatrix.m30(baseMatrix.m30() + (float)pos.field_1352).m31(baseMatrix.m31() + (float)pos.field_1351).m32(baseMatrix.m32() + (float)pos.field_1350);
        return baseMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    public static IntIntPair getTextureDimensions(class_2960 texture) {
        GpuTexture gpuTexture = class_310.method_1551().method_1531().method_4619(texture).method_68004();
        return IntIntPair.of((int)gpuTexture.getWidth(0), (int)gpuTexture.getHeight(0));
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static class_2960 getEmissiveResource(class_2960 textureLocation) {
        return textureLocation.method_45134(path -> path.replace(".png", "_glowmask.png"));
    }

    public static @Nullable GeoReplacedEntityRenderer<?, ?, ?> getReplacedEntityRenderer(class_1299<?> entityType) {
        GeoReplacedEntityRenderer replacedEntityRenderer;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        return v instanceof GeoReplacedEntityRenderer ? (replacedEntityRenderer = (GeoReplacedEntityRenderer)v) : null;
    }

    public static @Nullable GeoItemRenderer<?> getGeckoLibItemRenderer(class_1792 item) {
        return GeoRenderProvider.of(item).getGeoItemRenderer();
    }

    public static @Nullable GeoEntityRenderer<?, ?> getGeckoLibEntityRenderer(class_1299<?> entityType) {
        GeoEntityRenderer geoEntityRenderer;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        return v instanceof GeoEntityRenderer ? (geoEntityRenderer = (GeoEntityRenderer)v) : null;
    }

    public static @Nullable GeoBlockRenderer<?, ?> getGeckoLibBlockRenderer(class_2591<?> blockEntityType) {
        GeoBlockRenderer geoBlockRenderer;
        Object v = class_310.method_1551().method_31975().field_4345.get(blockEntityType);
        return v instanceof GeoBlockRenderer ? (geoBlockRenderer = (GeoBlockRenderer)v) : null;
    }

    public static @Nullable GeoArmorRenderer<?, ?> getGeckoLibArmorRenderer(class_1792 item) {
        class_1799 stack = item.method_7854();
        class_10192 equippable = (class_10192)stack.method_58695(class_9334.field_54196, null);
        if (equippable == null) {
            return null;
        }
        return RenderUtil.getGeckoLibArmorRenderer(stack, equippable.comp_3174());
    }

    public static @Nullable GeoArmorRenderer<?, ?> getGeckoLibArmorRenderer(class_1799 stack, class_1304 slot) {
        return GeoRenderProvider.of(stack).getGeoArmorRenderer(stack, slot);
    }

    public static @Nullable GeoAnimatable getReplacedAnimatable(class_1299<?> entityType) {
        GeoReplacedEntityRenderer<?, ?, ?> replacedEntityRenderer = RenderUtil.getReplacedEntityRenderer(entityType);
        return replacedEntityRenderer == null ? null : (GeoAnimatable)replacedEntityRenderer.getAnimatable();
    }

    private RenderUtil() {
    }
}

